﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using PsgBase;
using PsgIntl;

namespace Customers
{
    [EditorClass, ViewGrid]
    public partial class Customers : Base
    {
        #region Members
        CustomersBE.CustomersDataTable table = new CustomersBE.CustomersDataTable();
        CustomersBE.CustomersRow rowA = null;
        #endregion

        #region Constructors

        public Customers()
        {
            InitializeComponent();
        }

        public Customers(ViewGrid _browser)
            : base(_browser)
        {
            InitializeComponent();
        }

        public Customers(LookupGrid _search)
            : base(_search)
        {
            InitializeComponent();
        }

        #endregion

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "customerid";
            context.PsgFieldDisplay = "companyname";
            context.PsgCommand = "customers";
            context.PsgServerTableName = "customers";
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddTable("customers", ID, "C");
            GetTables(this);
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "CUSTOMERS":
                    table = (CustomersBE.CustomersDataTable)SetMainData(dt, table);
                    rowA = (CustomersBE.CustomersRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edCustomer, table.companynameColumn);
            BindEdit(edContactNam, table.contactnameColumn);
            BindEdit(edContactTitle, table.contacttitleColumn);
            BindEdit(edAddress, table.addressColumn);
            BindEdit(edCity, table.cityColumn);
            BindEdit(edRegion, table.regionColumn);
            BindEdit(edPostalCode, table.postalcodeColumn);
            BindEdit(edPhone, table.phoneColumn);
            BindEdit(edFax, table.faxColumn);

            base.PsgBind();
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.companynameColumn, GetIntl(Intl.Customer), 150);
            this.ColumnsView(table.contactnameColumn, GetIntl(Intl.Contact_name), 150);
            this.ColumnsView(table.contacttitleColumn, GetIntl(Intl.Contact_title), 150);
            this.ColumnsView(table.postalcodeColumn, GetIntl(Intl.Postal_Code));
            this.ColumnsView(table.addressColumn, GetIntl(Intl.Address), 150);
            this.ColumnsView(table.cityColumn, GetIntl(Intl.City));
            this.ColumnsView(table.regionColumn, GetIntl(Intl.Region));
            this.ColumnsView(table.countryColumn, GetIntl(Intl.Country));
            this.ColumnsView(table.phoneColumn, GetIntl(Intl.Phone_numbers));
            this.ColumnsView(table.faxColumn, GetIntl(Intl.Fax));

            this.FiltersView(table.companynameColumn, GetIntl(Intl.Customer));
            this.FiltersView(table.contactnameColumn, GetIntl(Intl.Contact_name));
            this.FiltersView(table.contacttitleColumn, GetIntl(Intl.Contact_title));
            this.FiltersView(table.postalcodeColumn, GetIntl(Intl.Postal_Code));
            this.FiltersView(table.addressColumn, GetIntl(Intl.Address));
            this.FiltersView(table.cityColumn, GetIntl(Intl.City));
            this.FiltersView(table.regionColumn, GetIntl(Intl.Region));
            this.FiltersView(table.countryColumn, GetIntl(Intl.Country));
            this.FiltersView(table.phoneColumn, GetIntl(Intl.Phone_numbers));
            this.FiltersView(table.faxColumn, GetIntl(Intl.Fax));
        }
    }
}
